/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.utils;

import android.os.Build;
import android.support.annotation.Keep;
import com.kwad.sdk.crash.model.message.FastUnwindBackTraceElement;
import com.kwad.sdk.crash.model.message.FastUnwindBacktrace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

@Keep
public class BacktraceUtil {
    private static boolean sIsInit = false;
    private static FastUnwindBackTraceElement sNativePollOnceElement;
    private static final Set<FastUnwindBackTraceElement> sUnwindSet;
    private static final Set<FastUnwindBackTraceElement> sIgnoreSet;
    private static final Map<Long, Integer> sThreadIdMap;

    private static native int InitUtil();

    private static native String GetThreadFrameInfo(Object var0, boolean var1, boolean var2, boolean var3);

    private static native StackTraceElement[] FrameInfoToTrace(String var0);

    private static native FastUnwindBackTraceElement[] FrameInfoToNativeTrace(String var0);

    private static native boolean UnwindTraceElement(FastUnwindBackTraceElement var0);

    private static native void HookLogMessage();

    private static native void HookUnwind();

    private static native int GetThreadNativeTid(Thread var0);

    public static int init() {
        int n2 = BacktraceUtil.InitUtil();
        sIsInit = true;
        return n2;
    }

    public static String getThreadFrameInfo(Thread thread, Boolean bl2) {
        return BacktraceUtil.getThreadFrameInfo(thread, bl2, Boolean.TRUE, Boolean.TRUE);
    }

    public static String getThreadFrameInfo(Thread thread, Boolean bl2, Boolean bl3, Boolean bl4) {
        if (!sIsInit) {
            return null;
        }
        if (bl2 == null) {
            bl2 = thread == Thread.currentThread();
        }
        return BacktraceUtil.GetThreadFrameInfo(thread, bl2, bl3, bl4);
    }

    public static Object[] frameInfoToTraceElements(String serializableArray) {
        StackTraceElement[] stackTraceElementArray = BacktraceUtil.FrameInfoToTrace((String)serializableArray);
        if (stackTraceElementArray == null) {
            return new StackTraceElement[0];
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        if ((serializableArray = BacktraceUtil.FrameInfoToNativeTrace((String)serializableArray)) != null) {
            for (Serializable serializable : serializableArray) {
                if (!((FastUnwindBackTraceElement)serializable).hasUnwind) continue;
                arrayList.add(serializable);
            }
        }
        serializableArray = stackTraceElementArray;
        int n2 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Serializable serializable;
            serializable = serializableArray[i2];
            if (((StackTraceElement)serializable).getMethodName() == null || ((StackTraceElement)serializable).getMethodName().isEmpty()) continue;
            arrayList.add(serializable);
        }
        return arrayList.toArray();
    }

    public static Object[] backtraceInfoToArrays(FastUnwindBacktrace fastUnwindBacktrace) {
        ArrayList<FastUnwindBackTraceElement> arrayList = new ArrayList<FastUnwindBackTraceElement>();
        if (fastUnwindBacktrace != null) {
            arrayList.addAll(fastUnwindBacktrace.backtraces);
        }
        return arrayList.toArray();
    }

    public static ThreadStateAndLockInfo getThreadStateAndLockInfo(FastUnwindBacktrace fastUnwindBacktrace) {
        String[] stringArray;
        if (fastUnwindBacktrace == null || fastUnwindBacktrace.threadDumpStr.isEmpty()) {
            return null;
        }
        if (fastUnwindBacktrace.threadStateStr.isEmpty()) {
            int n2 = fastUnwindBacktrace.threadDumpStr.indexOf(",Thread");
            stringArray = fastUnwindBacktrace.threadDumpStr.substring(0, n2);
            int n3 = stringArray.lastIndexOf(",") + 1;
            fastUnwindBacktrace.threadStateStr = stringArray.substring(n3);
        }
        ThreadStateAndLockInfo threadStateAndLockInfo = new ThreadStateAndLockInfo();
        new ThreadStateAndLockInfo().threadState = fastUnwindBacktrace.threadStateStr;
        if (Build.VERSION.SDK_INT >= 28) {
            threadStateAndLockInfo.tid = fastUnwindBacktrace.threadId;
            threadStateAndLockInfo.lockClassName = fastUnwindBacktrace.lockType;
        } else {
            stringArray = fastUnwindBacktrace.lockMsg.split("held by thread");
            String string2 = stringArray[stringArray.length - 1].trim();
            try {
                threadStateAndLockInfo.tid = Integer.parseInt(string2);
                threadStateAndLockInfo.threadState = "Blocked";
                int n4 = fastUnwindBacktrace.lockMsg.indexOf("(a ") + 3;
                int n5 = fastUnwindBacktrace.lockMsg.indexOf(")");
                if (n4 > 0 && n5 > n4) {
                    threadStateAndLockInfo.lockClassName = fastUnwindBacktrace.lockMsg.substring(n4, n5);
                }
            }
            catch (Exception exception) {}
        }
        return threadStateAndLockInfo;
    }

    private static int objArrayRealSize(Object[] objectArray) {
        for (int i2 = objectArray.length - 1; i2 > 0; --i2) {
            if (objectArray[i2] == null) continue;
            return i2 + 1;
        }
        return 0;
    }

    public static boolean isNativePollOnce(FastUnwindBacktrace object) {
        if (object != null && !((FastUnwindBacktrace)object).backtraces.isEmpty()) {
            for (FastUnwindBackTraceElement fastUnwindBackTraceElement : ((FastUnwindBacktrace)object).backtraces) {
                if (fastUnwindBackTraceElement.isNative) continue;
                if (sNativePollOnceElement != null) {
                    return sNativePollOnceElement.equals(fastUnwindBackTraceElement);
                }
                boolean bl2 = BacktraceUtil.unwindTraceElement(fastUnwindBackTraceElement);
                if (!bl2 || !fastUnwindBackTraceElement.declaringClass.equals("android.os.MessageQueue") || !fastUnwindBackTraceElement.methodName.equals("nativePollOnce") || fastUnwindBackTraceElement.lineNumber != -2) break;
                sNativePollOnceElement = FastUnwindBackTraceElement.obtainFastUnwindBackTraceElement(fastUnwindBackTraceElement);
                return true;
            }
        }
        return false;
    }

    public static boolean unwindTraceElement(FastUnwindBackTraceElement fastUnwindBackTraceElement) {
        return BacktraceUtil.UnwindTraceElement(fastUnwindBackTraceElement);
    }

    public static List<FastUnwindBackTraceElement> unwindTraceElements(List<FastUnwindBackTraceElement> object) {
        if (object == null) {
            return null;
        }
        ArrayList<FastUnwindBackTraceElement> arrayList = new ArrayList<FastUnwindBackTraceElement>();
        object = object.iterator();
        block0: while (object.hasNext()) {
            FastUnwindBackTraceElement fastUnwindBackTraceElement = (FastUnwindBackTraceElement)object.next();
            if (fastUnwindBackTraceElement.hasUnwind) {
                arrayList.add(fastUnwindBackTraceElement);
                continue;
            }
            if (sIgnoreSet.contains(fastUnwindBackTraceElement)) {
                fastUnwindBackTraceElement.isIgnore = true;
                continue;
            }
            if (fastUnwindBackTraceElement.isEmpty()) {
                fastUnwindBackTraceElement.isIgnore = true;
                continue;
            }
            if (sUnwindSet.contains(fastUnwindBackTraceElement)) {
                for (FastUnwindBackTraceElement fastUnwindBackTraceElement2 : sUnwindSet) {
                    if (!fastUnwindBackTraceElement2.equals(fastUnwindBackTraceElement)) continue;
                    fastUnwindBackTraceElement.updateTraceInfo(fastUnwindBackTraceElement2);
                    fastUnwindBackTraceElement.hasUnwind = true;
                    fastUnwindBackTraceElement2.lastUpdateTime = fastUnwindBackTraceElement.updateTime;
                    arrayList.add(fastUnwindBackTraceElement);
                    continue block0;
                }
                continue;
            }
            boolean bl2 = BacktraceUtil.unwindTraceElement(fastUnwindBackTraceElement);
            if (bl2) {
                fastUnwindBackTraceElement.hasUnwind = true;
                sUnwindSet.add(fastUnwindBackTraceElement);
                arrayList.add(fastUnwindBackTraceElement);
                continue;
            }
            fastUnwindBackTraceElement.isIgnore = true;
            sIgnoreSet.add(fastUnwindBackTraceElement);
        }
        return arrayList;
    }

    public static void hookLogMessage() {
        BacktraceUtil.HookLogMessage();
    }

    public static void hookUnwind() {
        BacktraceUtil.HookUnwind();
    }

    public static int getThreadNativeTid(Thread thread) {
        if (sThreadIdMap.containsKey(thread.getId())) {
            return sThreadIdMap.get(thread.getId());
        }
        int n2 = BacktraceUtil.GetThreadNativeTid(thread);
        sThreadIdMap.put(thread.getId(), n2);
        return n2;
    }

    static {
        sUnwindSet = new CopyOnWriteArraySet<FastUnwindBackTraceElement>();
        sIgnoreSet = new CopyOnWriteArraySet<FastUnwindBackTraceElement>();
        sThreadIdMap = new HashMap<Long, Integer>();
    }

    public static class ThreadStateAndLockInfo
    implements Serializable {
        public static final String STATE_BLOCKED = "Blocked";
        public static final String STATE_WAITING_FOR_LOCK_INFLATION = "WaitingForLockInflation";
        public int tid;
        public String lockClassName;
        public String threadState;
        public long updateTime;

        public boolean isBlock() {
            return this.threadState.equals(STATE_BLOCKED) || this.threadState.equals(STATE_WAITING_FOR_LOCK_INFLATION);
        }
    }
}

