/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.utils;

import android.support.annotation.Keep;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Keep
public class JvmtiHelper {
    public static final String TAG = "jvmti";
    public static final String KEY = "TI_PERF_MONITOR";
    private static final int MB = 0x100000;
    private static final long LOW_MEM_THRESHOLD = 0xC800000L;
    private static final int MIN_INTERVAL = 10;
    private static final String AGENT_LIB = "ti-monitor";
    private static final long DELAY_MS = 200L;
    private static final int MIN_CLASS_LEN = 0xA00000;
    private static final int MIN_ALLOC_SIZE = 0x300000;
    private static boolean isJdwpEnable = false;
    private static long preAllocEventTime = 0L;
    private static String preAllocMsg;
    private static String preClassLoadMsg;
    private static int mAllocRealSetting;
    private static int mLoadSizeRealSetting;
    private static boolean mLoaded;

    public static native boolean enableJdwp();

    private static native void setConfig(int var0, int var1, int var2, int var3, boolean var4, boolean var5, String var6, boolean var7);

    public static native boolean disableJdwp();

    private static native boolean unloadAgent();

    public static native boolean avoidDeoptForReleaseBuild();

    private static native long getObjectSize(Object var0);

    public static boolean isJDWPEnable() {
        return isJdwpEnable;
    }

    private static native boolean loadTiAgent();

    private static native StackTraceElement[] frameInfoToTrace(String var0);

    private static boolean unlikely(boolean bl2) {
        return bl2;
    }

    public static boolean loadLibrary(String string2) {
        try {
            GenericDeclaration genericDeclaration = Class.class.getDeclaredMethod("forName", String.class);
            Method method = Class.class.getDeclaredMethod("getDeclaredMethod", String.class, Class[].class);
            genericDeclaration = (Class)genericDeclaration.invoke(null, "java.lang.System");
            method = (Method)method.invoke((Object)genericDeclaration, "loadLibrary", new Class[]{String.class});
            method.invoke((Object)genericDeclaration, string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessException illegalAccessException2 = illegalAccessException;
            illegalAccessException.printStackTrace();
        }
        return true;
    }

    @RequiresApi(api=26)
    public static boolean ensureAgentLoad() {
        JvmtiHelper.loadLibrary("openjdkjvmti");
        return true;
    }

    private static void doAllocAsyncReport(String string2, long l2) {
    }

    private static void doGCAsyncReport(String string2) {
        System.currentTimeMillis();
    }

    private static void doClazzLoadAsyncReport(String string2) {
        System.currentTimeMillis();
    }

    @Keep
    public static void logEvent(String object) {
        try {
            if (TextUtils.isEmpty((CharSequence)object)) {
                return;
            }
            if (((String)object).startsWith("alloc_obj")) {
                long l2 = System.currentTimeMillis();
                if (l2 - preAllocEventTime < 10L || ((String)object).equals(preAllocMsg)) {
                    preAllocEventTime = l2;
                    preAllocMsg = object;
                    return;
                }
                preAllocEventTime = l2;
                preAllocMsg = object;
                JvmtiHelper.doAllocAsyncReport((String)object, l2);
                return;
            }
            if (((String)object).startsWith("gc_start")) {
                JvmtiHelper.doGCAsyncReport((String)object);
                return;
            }
            if (((String)object).startsWith("class_load")) {
                if (((String)object).equals(preClassLoadMsg)) {
                    return;
                }
                preClassLoadMsg = object;
                JvmtiHelper.doClazzLoadAsyncReport((String)object);
                return;
            }
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Keep
    public static void fastUnwindStack(String stackTraceElementArray) {
        try {
            StackTraceElement[] stackTraceElementArray2 = JvmtiHelper.frameInfoToTrace((String)stackTraceElementArray);
            stackTraceElementArray = stackTraceElementArray2;
            stackTraceElementArray = stackTraceElementArray2;
            int n2 = stackTraceElementArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i2];
                Log.d((String)TAG, (String)("TODO(deal) " + stackTraceElement.toString()));
            }
            return;
        }
        catch (Exception exception) {
            stackTraceElementArray = exception;
            exception.printStackTrace();
            return;
        }
    }

    public static int getAllocSizeRealSetting() {
        return mAllocRealSetting;
    }

    public static int getLoadSizeRealSetting() {
        return mLoadSizeRealSetting;
    }

    public static void unloadTiAgent() {
        if (mLoaded) {
            JvmtiHelper.unloadAgent();
            mLoaded = false;
        }
    }

    public static boolean isLoaded() {
        return mLoaded;
    }

    static {
        mAllocRealSetting = 0;
        mLoadSizeRealSetting = 0;
        mLoaded = false;
    }
}

