/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.kwad.sdk.api.a.a;
import com.kwad.sdk.api.a.b;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.LiteOADIDSDKHelper25;
import com.kwad.sdk.liteapi.LiteSDKDeviceController;
import com.kwad.sdk.liteapi.oaid.OADIDSDKHelper;
import com.kwad.sdk.liteapi.oaid.helpers.ASUSDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.HONORDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.HWDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.LenovoDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.MeizuDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.NubiaDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.OppoDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.SamsungDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.VivoDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.XiaomiDeviceIDHelper;
import com.kwad.sdk.liteapi.oaid.helpers.ZTEDeviceIDHelper;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public class LiteOAIDHelper {
    private static final String KEY_OAID = "kasd_oaid_key";
    private static final String TAG = "OAIDHelper";
    private static String sOAID = "";
    private static boolean sGetOaidFail = false;
    private static final AtomicBoolean sInitIng = new AtomicBoolean();
    private static final AtomicBoolean sHasReadSp = new AtomicBoolean();

    public static String getAppOAID(Context context) {
        if (LiteSDKDeviceController.useOaidDisable() && !TextUtils.isEmpty((CharSequence)LiteSDKDeviceController.getDevOaid())) {
            return LiteSDKDeviceController.getDevOaid();
        }
        if (!TextUtils.isEmpty((CharSequence)sOAID)) {
            return sOAID;
        }
        if (LiteSDKDeviceController.useOaidDisable()) {
            return sOAID;
        }
        LiteOAIDHelper.initAsync(context);
        return sOAID;
    }

    public static String obtainCurrent() {
        return sOAID;
    }

    private static void initAsync(final Context context) {
        if (context == null) {
            return;
        }
        if (sInitIng.getAndSet(true)) {
            return;
        }
        a.a(new b(){

            @Override
            public final void doTask() {
                if (!TextUtils.isEmpty((CharSequence)sOAID)) {
                    return;
                }
                LiteOAIDHelper.getOAIDNormal(context);
                if (OADIDSDKHelper.isSupport()) {
                    OADIDSDKHelper.getOAId(context, new OADIDSDKHelper.a(){

                        @Override
                        public final void OnOAIDValid(String string) {
                            sOAID = string;
                        }
                    });
                } else if (LiteOADIDSDKHelper25.isSupport()) {
                    LiteOADIDSDKHelper25.getOAId((Context)context, (LiteOADIDSDKHelper25.OAIDListener)new LiteOADIDSDKHelper25.OAIDListener(){});
                }
                sInitIng.set(false);
            }
        });
    }

    private static void getOAIDNormal(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sOAID) || context == null) {
            return;
        }
        if (sGetOaidFail) {
            return;
        }
        context = context.getApplicationContext();
        try {
            String string;
            switch (string = Build.MANUFACTURER.toUpperCase()) {
                case "HUAWEI": {
                    sOAID = new HWDeviceIDHelper(context).getOAID();
                    break;
                }
                case "HONOR": {
                    sOAID = new HONORDeviceIDHelper(context).getOAID();
                    break;
                }
                case "XIAOMI": 
                case "BLACKSHARK": {
                    sOAID = new XiaomiDeviceIDHelper(context).getOAID();
                    break;
                }
                case "OPPO": 
                case "ONEPLUS": {
                    sOAID = new OppoDeviceIDHelper(context).getOAID();
                    break;
                }
                case "VIVO": {
                    sOAID = new VivoDeviceIDHelper(context).getOAID();
                    break;
                }
                case "LENOVO": 
                case "MOTOLORA": {
                    sOAID = new LenovoDeviceIDHelper(context).getOAID();
                    break;
                }
                case "MEIZU": {
                    sOAID = new MeizuDeviceIDHelper(context).getOAID();
                    break;
                }
                case "NUBIA": {
                    sOAID = new NubiaDeviceIDHelper(context).getOAID();
                    break;
                }
                case "SAMSUNG": {
                    sOAID = new SamsungDeviceIDHelper(context).getOAID();
                    break;
                }
                case "ASUS": {
                    sOAID = new ASUSDeviceIDHelper(context).getOAID();
                    break;
                }
                case "ZTE": 
                case "FERRMEOS": 
                case "SSUI": {
                    sOAID = new ZTEDeviceIDHelper(context).getOAID();
                }
            }
            LiteApiLogger.i(TAG, "manufacturer:" + string + "--OAID:" + sOAID);
            if (TextUtils.isEmpty((CharSequence)sOAID)) {
                sGetOaidFail = true;
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            LiteApiLogger.printStackTraceOnly(throwable);
            return;
        }
    }
}

