/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public class PackageManagerUtils {
    private static long packageInfoLimiter = 0L;
    private static long mLastCallTime = 0L;
    private static HashMap<String, PackageInfo> sPackageInfoHashMap;
    public static AtomicBoolean mHasInit;

    public static PackageInfo getPackageInfo(Context object, String string, int n2) {
        try {
            PackageManagerUtils.init(object);
            if (sPackageInfoHashMap != null && sPackageInfoHashMap.containsKey(string)) {
                return sPackageInfoHashMap.get(string);
            }
            if (PackageManagerUtils.shouldCall()) {
                try {
                    object = object.getPackageManager().getPackageInfo(string, n2);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    object = null;
                }
                if (sPackageInfoHashMap != null) {
                    sPackageInfoHashMap.put(string, (PackageInfo)object);
                }
                return object;
            }
            LiteApiLogger.d("PackageInfoLimiter", "\u8c03\u7528\u9891\u6b21\u8fc7\u9ad8\uff0c\u8df3\u8fc7\u672c\u6b21\u8c03\u7528");
        }
        catch (Throwable throwable) {
            object = throwable;
            LiteApiLogger.printStackTraceOnly(throwable);
        }
        return null;
    }

    public static PackageInfo getPackageInfoNoCache(Context object, String string, int n2) {
        try {
            PackageManagerUtils.init(object);
            if (PackageManagerUtils.shouldCall()) {
                try {
                    object = object.getPackageManager().getPackageInfo(string, n2);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    object = null;
                }
                if (sPackageInfoHashMap != null) {
                    sPackageInfoHashMap.put(string, (PackageInfo)object);
                }
                return object;
            }
            LiteApiLogger.d("PackageInfoLimiter", "\u8c03\u7528\u9891\u6b21\u8fc7\u9ad8\uff0c\u8df3\u8fc7\u672c\u6b21\u8c03\u7528");
        }
        catch (Throwable throwable) {
            object = throwable;
            LiteApiLogger.printStackTraceOnly(throwable);
        }
        return null;
    }

    private static synchronized boolean shouldCall() {
        if (packageInfoLimiter <= 0L) {
            return true;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - mLastCallTime > packageInfoLimiter) {
            mLastCallTime = l2;
            return true;
        }
        return false;
    }

    private static void init(Context context) {
        if (mHasInit.compareAndSet(false, true) && (packageInfoLimiter = context.getSharedPreferences("ksadsdk_config", 0).getLong("packageInfoLimiter", 0L)) > 0L) {
            sPackageInfoHashMap = new HashMap();
        }
    }

    static {
        mHasInit = new AtomicBoolean(false);
    }
}

