/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.encrypt;

import android.support.annotation.Keep;
import android.text.TextUtils;
import java.nio.charset.Charset;
import java.util.Arrays;

@Keep
public class KsBase64 {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final String PRE = "sDAkk/dS";

    private KsBase64() {
    }

    public static b getEncoder() {
        return b.aSr;
    }

    public static b getUrlSafeEncoder() {
        return b.aSs;
    }

    public static a getDecoder() {
        return a.aSo;
    }

    public static a getMimeDecoder() {
        return a.aSq;
    }

    public static a getUrlSafeDecoder() {
        return a.aSp;
    }

    public static String encodeKsSdk(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return PRE + new String(KsBase64.getEncoder().encode(string.getBytes()), UTF_8);
    }

    public static String decodeKsSdk(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        if (string.startsWith(PRE)) {
            return new String(KsBase64.getDecoder().decode(string.substring(8)), UTF_8);
        }
        return string;
    }

    public static boolean isEncodeKsSdk(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.startsWith(PRE);
    }

    public static final class a {
        static final a aSo;
        static final a aSp;
        static final a aSq;
        private static final int[] fromBase64;
        private static final int[] fromBase64URL;
        private final boolean isURL;
        private final boolean isMIME;

        private a(boolean bl2, boolean bl3) {
            this.isURL = bl2;
            this.isMIME = bl3;
        }

        public final byte[] decode(byte[] byArray) {
            byte[] byArray2 = new byte[this.outLength(byArray, 0, byArray.length)];
            int n2 = this.decode0(byArray, 0, byArray.length, byArray2);
            if (n2 != byArray2.length) {
                byArray2 = Arrays.copyOf(byArray2, n2);
            }
            return byArray2;
        }

        public final byte[] decode(String string) {
            return this.decode(string.getBytes(ISO_8859_1));
        }

        private int outLength(byte[] byArray, int n2, int n3) {
            int[] nArray = this.isURL ? fromBase64URL : fromBase64;
            int n4 = 0;
            int n5 = n3 - 0;
            if (n5 == 0) {
                return 0;
            }
            if (n5 < 2) {
                if (this.isMIME && nArray[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            if (this.isMIME) {
                int n6 = 0;
                while (n2 < n3) {
                    int n7;
                    if ((n7 = byArray[n2++] & 0xFF) == 61) {
                        n5 -= n3 - n2 + 1;
                        break;
                    }
                    if (nArray[n7] != -1) continue;
                    ++n6;
                }
                n5 -= n6;
            } else if (byArray[n3 - 1] == 61) {
                ++n4;
                if (byArray[n3 - 2] == 61) {
                    ++n4;
                }
            }
            if (n4 == 0 && (n5 & 3) != 0) {
                n4 = 4 - (n5 & 3);
            }
            return 3 * ((n5 + 3) / 4) - n4;
        }

        private int decode0(byte[] byArray, int n2, int n3, byte[] byArray2) {
            int[] nArray = this.isURL ? fromBase64URL : fromBase64;
            int n4 = 0;
            int n5 = 0;
            int n6 = 18;
            while (n2 < n3) {
                int n7 = byArray[n2++] & 0xFF;
                if ((n7 = nArray[n7]) < 0) {
                    if (n7 == -2) {
                        if ((n6 != 6 || n2 != n3 && byArray[n2++] == 61) && n6 != 18) break;
                        throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                    }
                    if (this.isMIME) continue;
                    throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(byArray[n2 - 1], 16));
                }
                n5 |= n7 << n6;
                if ((n6 -= 6) >= 0) continue;
                byArray2[n4++] = (byte)(n5 >> 16);
                byArray2[n4++] = (byte)(n5 >> 8);
                byArray2[n4++] = (byte)n5;
                n6 = 18;
                n5 = 0;
            }
            if (n6 == 6) {
                byArray2[n4++] = (byte)(n5 >> 16);
            } else if (n6 == 0) {
                byArray2[n4++] = (byte)(n5 >> 16);
                byArray2[n4++] = (byte)(n5 >> 8);
            } else if (n6 == 12) {
                throw new IllegalArgumentException("Last unit does not have enough valid bits");
            }
            while (n2 < n3) {
                if (this.isMIME && nArray[byArray[n2++]] < 0) continue;
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + n2);
            }
            return n4;
        }

        static {
            int n2;
            aSo = new a(false, false);
            aSp = new a(true, false);
            aSq = new a(false, true);
            fromBase64 = new int[256];
            fromBase64URL = new int[256];
            Arrays.fill(fromBase64, -1);
            for (n2 = 0; n2 < b.toBase64.length; ++n2) {
                a.fromBase64[b.toBase64[n2]] = n2;
            }
            a.fromBase64[61] = -2;
            Arrays.fill(fromBase64URL, -1);
            for (n2 = 0; n2 < b.toBase64URL.length; ++n2) {
                a.fromBase64URL[b.toBase64URL[n2]] = n2;
            }
            a.fromBase64URL[61] = -2;
        }
    }

    public static final class b {
        static final b aSr = new b(false, null, -1, true);
        static final b aSs = new b(true, null, -1, false);
        private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private static final char[] toBase64URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        private final byte[] newline;
        private final int linemax;
        private final boolean isURL;
        private final boolean doPadding;

        private b(boolean bl2, byte[] byArray, int n2, boolean bl3) {
            this.isURL = bl2;
            this.newline = null;
            this.linemax = -1;
            this.doPadding = bl3;
        }

        private final int outLength(int n2) {
            if (this.doPadding) {
                n2 = 4 * ((n2 + 2) / 3);
            } else {
                int n3 = n2 % 3;
                n2 = 4 * (n2 / 3) + (n3 == 0 ? 0 : n3 + 1);
            }
            if (this.linemax > 0) {
                int n4 = n2;
                n2 = n4 + (n4 - 1) / this.linemax * this.newline.length;
            }
            return n2;
        }

        public final byte[] encode(byte[] byArray) {
            int n2 = this.outLength(byArray.length);
            byte[] byArray2 = new byte[n2];
            int n3 = this.encode0(byArray, 0, byArray.length, byArray2);
            if (n3 != byArray2.length) {
                return Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }

        private int encode0(byte[] byArray, int n2, int n3, byte[] byArray2) {
            int n4;
            int n5;
            char[] cArray = this.isURL ? toBase64URL : toBase64;
            int n6 = 0;
            int n7 = (n3 - 0) / 3 * 3;
            int n8 = 0 + n7;
            if (this.linemax > 0 && n7 > this.linemax / 4 * 3) {
                n7 = this.linemax / 4 * 3;
            }
            int n9 = 0;
            while (n6 < n8) {
                int n10;
                n5 = Math.min(n6 + n7, n8);
                n4 = n6;
                int n11 = n9;
                while (n4 < n5) {
                    n10 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                    byArray2[n11++] = (byte)cArray[n10 >>> 18 & 0x3F];
                    byArray2[n11++] = (byte)cArray[n10 >>> 12 & 0x3F];
                    byArray2[n11++] = (byte)cArray[n10 >>> 6 & 0x3F];
                    byArray2[n11++] = (byte)cArray[n10 & 0x3F];
                }
                n4 = (n5 - n6) / 3 * 4;
                n9 += n4;
                n6 = n5;
                if (n4 != this.linemax || n6 >= n3) continue;
                byte[] byArray3 = this.newline;
                n10 = this.newline.length;
                for (n5 = 0; n5 < n10; ++n5) {
                    n4 = byArray3[n5];
                    byArray2[n9++] = n4;
                }
            }
            if (n6 < n3) {
                n5 = byArray[n6++] & 0xFF;
                byArray2[n9++] = (byte)cArray[n5 >> 2];
                if (n6 == n3) {
                    byArray2[n9++] = (byte)cArray[n5 << 4 & 0x3F];
                    if (this.doPadding) {
                        byArray2[n9++] = 61;
                        byArray2[n9++] = 61;
                    }
                } else {
                    n4 = byArray[n6] & 0xFF;
                    byArray2[n9++] = (byte)cArray[n5 << 4 & 0x3F | n4 >> 4];
                    byArray2[n9++] = (byte)cArray[n4 << 2 & 0x3F];
                    if (this.doPadding) {
                        byArray2[n9++] = 61;
                    }
                }
            }
            return n9;
        }
    }
}

