/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.encrypt;

import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.utils.LiteCloseableUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

@Keep
final class LiteAESUtil {
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final int BUFFER = 1024;
    private static final boolean DEBUG = false;

    private LiteAESUtil() {
    }

    private static byte[] transform(byte[] object, byte[] byArray, int n2) {
        try {
            object = new SecretKeySpec((byte[])object, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(n2, (Key)object);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static byte[] encrypt(byte[] byArray, String string) {
        return LiteAESUtil.encrypt(byArray, string.getBytes(UTF_8));
    }

    public static byte[] encrypt(byte[] byArray, byte[] byArray2) {
        return LiteAESUtil.transform(byArray, byArray2, 1);
    }

    public static byte[] decrypt(String string, byte[] byArray) {
        return LiteAESUtil.transform(string.getBytes(UTF_8), byArray, 2);
    }

    public static byte[] decrypt(byte[] byArray, byte[] byArray2) {
        return LiteAESUtil.transform(byArray, byArray2, 2);
    }

    public static byte[] compress(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteArrayOutputStream = new ByteArrayOutputStream();
            LiteAESUtil.compress(byteArrayInputStream, byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.flush();
        }
        catch (Throwable throwable) {
            LiteCloseableUtil.closeQuietly(byteArrayOutputStream);
            LiteCloseableUtil.closeQuietly((Closeable)byteArrayInputStream);
            throw throwable;
        }
        LiteCloseableUtil.closeQuietly((Closeable)byteArrayOutputStream);
        LiteCloseableUtil.closeQuietly((Closeable)byteArrayInputStream);
        return byArray;
    }

    public static void compress(InputStream inputStream, OutputStream outputStream) {
        GZIPOutputStream gZIPOutputStream = null;
        try {
            int n2;
            gZIPOutputStream = new GZIPOutputStream(outputStream);
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray, 0, 1024)) != -1) {
                gZIPOutputStream.write(byArray, 0, n2);
            }
            gZIPOutputStream.finish();
            gZIPOutputStream.flush();
        }
        catch (Throwable throwable) {
            LiteCloseableUtil.closeQuietly(gZIPOutputStream);
            throw throwable;
        }
        LiteCloseableUtil.closeQuietly((Closeable)gZIPOutputStream);
    }

    public static byte[] decompress(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteArrayOutputStream = new ByteArrayOutputStream();
            LiteAESUtil.decompress(byteArrayInputStream, byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.flush();
        }
        catch (Throwable throwable) {
            LiteCloseableUtil.closeQuietly(byteArrayOutputStream);
            LiteCloseableUtil.closeQuietly((Closeable)byteArrayInputStream);
            throw throwable;
        }
        LiteCloseableUtil.closeQuietly((Closeable)byteArrayOutputStream);
        LiteCloseableUtil.closeQuietly((Closeable)byteArrayInputStream);
        return byArray;
    }

    public static void decompress(InputStream inputStream, OutputStream outputStream) {
        GZIPInputStream gZIPInputStream = null;
        try {
            int n2;
            gZIPInputStream = new GZIPInputStream(inputStream);
            byte[] byArray = new byte[1024];
            while ((n2 = gZIPInputStream.read(byArray, 0, 1024)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
        }
        catch (Throwable throwable) {
            LiteCloseableUtil.closeQuietly(gZIPInputStream);
            throw throwable;
        }
        LiteCloseableUtil.closeQuietly((Closeable)gZIPInputStream);
    }
}

