/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.encrypt;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.kwad.sdk.liteapi.KsSecSDKWrapper;
import com.kwad.sdk.liteapi.LiteApiLogger;
import java.util.Arrays;
import java.util.Map;

@Keep
public final class LiteKsSig1Util {
    private static final String TAG = "KsSig1Util";
    private static final String JOIN_STRING = "&";
    public static final String PARAM_SIGNATURE = "Ks-Sig1";
    private static final boolean DEBUG = false;

    public static void sigRequest(Context object, String string, Map<String, String> map, String string2) {
        string = LiteKsSig1Util.generateInputString(string, string2);
        object = LiteKsSig1Util.atlasSign(object, string);
        map.put(PARAM_SIGNATURE, (String)object);
    }

    private static String generateInputString(String string, String string2) {
        string = Uri.parse((String)string);
        return string.getPath() + JOIN_STRING + LiteKsSig1Util.getSortedQuery(string.getQuery()) + JOIN_STRING + string2;
    }

    private static String getSortedQuery(String objectArray) {
        if (TextUtils.isEmpty((CharSequence)objectArray)) {
            return LiteKsSig1Util.emptyIfNull((String)objectArray);
        }
        objectArray = objectArray.split(JOIN_STRING);
        Arrays.sort(objectArray);
        return TextUtils.join((CharSequence)JOIN_STRING, (Object[])objectArray);
    }

    private static String emptyIfNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String atlasSign(Context object, String string) {
        if (object == null || TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        try {
            object = KsSecSDKWrapper.doSign(object, string);
            if (object == null) {
                return "";
            }
            return object;
        }
        catch (Throwable throwable) {
            object = throwable;
            LiteApiLogger.printStackTraceOnly(throwable);
            return "";
        }
    }
}

