/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.encrypt;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.kwad.sdk.liteapi.encrypt.KsBase64;
import com.kwad.sdk.liteapi.encrypt.LiteAESUtil;
import com.kwad.sdk.liteapi.encrypt.LiteEncryptUtils;
import com.kwad.sdk.liteapi.encrypt.LiteKsSig1Util;
import com.kwad.sdk.liteapi.report.LiteSignatureUtils;
import java.util.Map;

@Keep
final class LiteRequestSigUtil {
    public static final String UTF_8 = "UTF-8";
    private static String sPkgId;

    LiteRequestSigUtil() {
    }

    public static void addHeaderParams(Context context, @NonNull Map<String, String> map) {
        map.put("Ks-PkgId", LiteRequestSigUtil.getPkgId(context));
        map.put("Ks-Encoding", "2");
    }

    public static String getRequestMessage(Context object, String string) {
        try {
            object = LiteEncryptUtils.getKey(object, 0);
            byte[] byArray = LiteAESUtil.compress(string.getBytes());
            object = LiteAESUtil.encrypt(object.getBytes(UTF_8), byArray);
            return new String(KsBase64.getEncoder().encode((byte[])object), UTF_8);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getResponseData(Context object, String string) {
        try {
            object = LiteEncryptUtils.getKey(object, 0);
            byte[] byArray = KsBase64.getDecoder().decode(string.getBytes());
            byte[] byArray2 = LiteAESUtil.decrypt((String)object, byArray);
            object = byArray2;
            object = LiteAESUtil.decompress(byArray2);
            return new String((byte[])object, UTF_8);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static void sigRequest(Context context, String string, Map<String, String> map, String string2) {
        LiteKsSig1Util.sigRequest(context, string, map, string2);
    }

    private static String getPkgId(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sPkgId)) {
            return sPkgId;
        }
        if (context == null) {
            return "";
        }
        sPkgId = context.getPackageName() + LiteSignatureUtils.getSignMd5Str(context);
        return sPkgId;
    }
}

