/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.text.TextUtils;
import android.util.Log;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.miitmdid.e;
import com.bun.miitmdid.interfaces.IIdentifierListener;
import com.bun.miitmdid.interfaces.IdSupplier;

@Keep
public class OADIDSDKHelper {
    private static final String TAG = "KSAdSDK";
    private static final String SUB_TAG = "OADIDSDKHelper:";
    private static boolean mIsRequestIng;
    private static boolean sGetOaidFail;

    public static void getOAId(Context context, a a2) {
        if (context == null || sGetOaidFail) {
            return;
        }
        if (!OADIDSDKHelper.isSupport()) {
            sGetOaidFail = true;
            return;
        }
        if (mIsRequestIng) {
            return;
        }
        mIsRequestIng = true;
        try {
            long l2 = System.currentTimeMillis();
            int n2 = MdidSdkHelper.InitSdk((Context)context.getApplicationContext(), (boolean)true, (IIdentifierListener)new IIdentifierListenerImpl(l2, a2));
            long l3 = System.currentTimeMillis() - l2;
            Log.d((String)TAG, (String)("OADIDSDKHelper:sdk init time=" + l3 + "--result=" + n2));
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)"OADIDSDKHelper:oaid sdk not find ");
            mIsRequestIng = false;
            sGetOaidFail = true;
            return;
        }
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean isSupport() {
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        try {
            IIdentifierListener iIdentifierListener = new IIdentifierListener(){

                public void onSupport(IdSupplier idSupplier) {
                }
            };
            iIdentifierListener.onSupport(null);
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)"OADIDSDKHelper:isSupport oaid sdk not find ");
            return false;
        }
        try {
            int n2 = e.a();
            Log.d((String)TAG, (String)("OADIDSDKHelper:oaidVersion" + n2));
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)"OADIDSDKHelper:oaidVersion fail");
            return false;
        }
        try {
            Class.forName("com.bun.miitmdid.core.MdidSdkHelper", false, OADIDSDKHelper.class.getClassLoader());
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)"OADIDSDKHelper:com.bun.miitmdid.core.MdidSdkHelper oaid sdk not find ");
            return false;
        }
        return true;
    }

    static {
        sGetOaidFail = false;
    }

    @Keep
    static class IIdentifierListenerImpl
    implements IIdentifierListener {
        private final long mStartTime;
        private final a mOaidListener;

        public IIdentifierListenerImpl(long l2, a a2) {
            this.mStartTime = l2;
            this.mOaidListener = a2;
        }

        public void onSupport(IdSupplier object) {
            long l2 = System.currentTimeMillis() - this.mStartTime;
            if (object != null) {
                if (!TextUtils.isEmpty((CharSequence)(object = object.getOAID()))) {
                    Log.d((String)OADIDSDKHelper.TAG, (String)("OADIDSDKHelper:oaid time=" + l2 + "--OAID:" + (String)object));
                    this.mOaidListener.OnOAIDValid((String)object);
                } else {
                    sGetOaidFail = true;
                }
            }
            mIsRequestIng = false;
        }
    }

    public static interface a {
        public void OnOAIDValid(String var1);
    }
}

