/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.oaid.interfaces.ASUSIDInterface;
import java.util.concurrent.LinkedBlockingQueue;

@Keep
public class ASUSDeviceIDHelper {
    private static final String TAG = "ASUSDeviceIDHelper";
    private Context mContext;
    private final LinkedBlockingQueue<IBinder> linkedBlockingQueue = new LinkedBlockingQueue(1);
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName object, IBinder iBinder) {
            try {
                ASUSDeviceIDHelper.this.linkedBlockingQueue.put(iBinder);
                return;
            }
            catch (Exception exception) {
                object = exception;
                LiteApiLogger.printStackTrace(exception);
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }
    };

    public ASUSDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public String getOAID() {
        String string;
        block7: {
            string = "";
            try {
                Intent intent = new Intent();
                intent.setAction("com.asus.msa.action.ACCESS_DID");
                ComponentName componentName = new ComponentName("com.asus.msa.SupplementaryDID", "com.asus.msa.SupplementaryDID.SupplementaryDIDService");
                intent.setComponent(componentName);
                boolean bl2 = this.mContext.bindService(intent, this.serviceConnection, 1);
                if (!bl2) break block7;
                try {
                    Object object = this.linkedBlockingQueue.take();
                    object = new ASUSIDInterface.a((IBinder)object);
                    string = object.getID();
                    LiteApiLogger.i(TAG, "getOAID oaid:" + string);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    LiteApiLogger.printStackTrace(exception);
                }
                finally {
                    this.mContext.unbindService(this.serviceConnection);
                }
            }
            catch (Exception exception) {
                LiteApiLogger.i(TAG, "getOAID asus service not found;");
                LiteApiLogger.printStackTrace(exception);
            }
        }
        return string;
    }
}

