/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.provider.Settings;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.oaid.helpers.HONORProxy;
import com.kwad.sdk.liteapi.oaid.interfaces.HONORInterface;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Keep
public class HONORDeviceIDHelper {
    private static final String TAG = "HONORDeviceIDHelper";
    private Context mContext;
    private final LinkedBlockingQueue<IBinder> mLinkedBlockingQueue = new LinkedBlockingQueue(1);
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                LiteApiLogger.d(HONORDeviceIDHelper.TAG, "onServiceConnected \uff1a " + iBinder);
                HONORDeviceIDHelper.this.mLinkedBlockingQueue.put(iBinder);
                return;
            }
            catch (Exception exception) {
                LiteApiLogger.d(HONORDeviceIDHelper.TAG, exception);
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }
    };

    public HONORDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public HONORProxy.c getAdInfo() {
        HONORProxy hONORProxy;
        block7: {
            hONORProxy = new HONORProxy();
            new HONORProxy().mContext = this.mContext;
            try {
                boolean bl2;
                Intent intent = new Intent();
                intent.setAction("com.hihonor.id.HnOaIdService");
                intent.setPackage("com.hihonor.id");
                if (!hONORProxy.isAdvertisingIdAvailable(this.mContext) || !(bl2 = this.mContext.bindService(intent, this.serviceConnection, 1))) break block7;
                try {
                    hONORProxy.info = new HONORProxy.c();
                    Object object = this.mLinkedBlockingQueue.take();
                    object = new HONORInterface.a((IBinder)object);
                    ((HONORInterface.a)object).getIDs(hONORProxy.mBinderOne);
                    ((HONORInterface.a)object).getBoos(hONORProxy.mBinderTwo);
                    hONORProxy.mCountDownLatch.await(3000L, TimeUnit.MICROSECONDS);
                }
                catch (Exception exception) {
                    LiteApiLogger.d(TAG, exception);
                }
                finally {
                    this.mContext.unbindService(this.serviceConnection);
                }
            }
            catch (Throwable throwable) {
                LiteApiLogger.d(TAG, "getOAID honor service not found" + throwable);
            }
        }
        return hONORProxy.info;
    }

    public String getOAID() {
        Object object;
        String string = "";
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                string = Settings.Global.getString((ContentResolver)this.mContext.getContentResolver(), (String)"oaid");
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"oaid");
            }
            LiteApiLogger.i(TAG, "getOAID secure: " + string);
        }
        catch (Throwable throwable) {
            object = throwable;
            LiteApiLogger.printStackTrace(throwable);
        }
        if (string != null && !string.isEmpty()) {
            return string;
        }
        object = this.getAdInfo();
        if (object != null) {
            return ((HONORProxy.c)object).aoB;
        }
        return "";
    }
}

