/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.oaid.interfaces.HWIDInterface;
import java.util.concurrent.LinkedBlockingQueue;

@Keep
public class HWDeviceIDHelper {
    private static final String TAG = "HWDeviceIDHelper";
    private Context mContext;
    private final LinkedBlockingQueue<IBinder> mLinkedBlockingQueue = new LinkedBlockingQueue(1);
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName object, IBinder iBinder) {
            try {
                LiteApiLogger.i(HWDeviceIDHelper.TAG, "onServiceConnected");
                HWDeviceIDHelper.this.mLinkedBlockingQueue.put(iBinder);
                return;
            }
            catch (Exception exception) {
                object = exception;
                LiteApiLogger.printStackTrace(exception);
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }
    };

    public HWDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public String getOAID() {
        String string;
        block7: {
            string = "";
            try {
                Intent intent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
                intent.setPackage("com.huawei.hwid");
                boolean bl2 = this.mContext.bindService(intent, this.serviceConnection, 1);
                if (!bl2) break block7;
                try {
                    Object object = this.mLinkedBlockingQueue.take();
                    object = new HWIDInterface.a((IBinder)object);
                    string = ((HWIDInterface.a)object).getIDs();
                    boolean bl3 = ((HWIDInterface.a)object).getBoos();
                    LiteApiLogger.i(TAG, "getOAID oaid:" + string + "--boos:" + bl3);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    LiteApiLogger.printStackTrace(exception);
                }
                finally {
                    this.mContext.unbindService(this.serviceConnection);
                }
            }
            catch (Exception exception) {
                LiteApiLogger.i(TAG, "getOAID hw service not found");
                LiteApiLogger.printStackTraceOnly(exception);
            }
        }
        return string;
    }
}

