/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.oaid.interfaces.LenovoIDInterface;
import java.util.concurrent.LinkedBlockingQueue;

@Keep
public class LenovoDeviceIDHelper {
    private static final String TAG = "LenovoDeviceIDHelper";
    private Context mContext;
    private final LinkedBlockingQueue<IBinder> mLinkedBlockingQueue = new LinkedBlockingQueue(1);
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName object, IBinder iBinder) {
            try {
                LiteApiLogger.i(LenovoDeviceIDHelper.TAG, "onServiceConnected");
                LenovoDeviceIDHelper.this.mLinkedBlockingQueue.put(iBinder);
                return;
            }
            catch (Exception exception) {
                object = exception;
                LiteApiLogger.printStackTrace(exception);
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }
    };

    public LenovoDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public String getOAID() {
        String string;
        block7: {
            string = "";
            try {
                Intent intent = new Intent();
                intent.setClassName("com.zui.deviceidservice", "com.zui.deviceidservice.DeviceidService");
                boolean bl2 = this.mContext.bindService(intent, this.serviceConnection, 1);
                if (!bl2) break block7;
                try {
                    Object object = this.mLinkedBlockingQueue.take();
                    object = new LenovoIDInterface.a((IBinder)object);
                    string = object.getOaid();
                    LiteApiLogger.i(TAG, "getOAID oaid:" + string);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    LiteApiLogger.printStackTrace(exception);
                }
                finally {
                    this.mContext.unbindService(this.serviceConnection);
                }
            }
            catch (Exception exception) {
                LiteApiLogger.i(TAG, "getOAID Lenovo service not found");
                LiteApiLogger.printStackTrace(exception);
            }
        }
        return string;
    }
}

