/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.oaid.helpers.OaidInnerUtils;
import java.io.Closeable;

@Keep
public class MeizuDeviceIDHelper {
    private static final String TAG = "MeizuDeviceIDHelper";
    private Context mContext;

    public MeizuDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public String getOAID() {
        String string;
        block7: {
            string = "";
            try {
                Cursor cursor = null;
                try {
                    Uri uri = Uri.parse((String)"content://com.meizu.flyme.openidsdk/");
                    ContentResolver contentResolver = this.mContext.getContentResolver();
                    cursor = contentResolver.query(uri, null, null, new String[]{"oaid"}, null);
                    string = this.getOaid(cursor);
                    LiteApiLogger.i(TAG, "getOAID oaid:" + string);
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace();
                        break block7;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        OaidInnerUtils.closeQuietly(cursor);
                    }
                }
                OaidInnerUtils.closeQuietly((Closeable)cursor);
            }
            catch (Exception exception) {
                LiteApiLogger.i(TAG, "getOAID service not found;");
                LiteApiLogger.printStackTrace(exception);
            }
        }
        return string;
    }

    private String getOaid(Cursor cursor) {
        String string = "";
        if (cursor == null || cursor.isClosed()) {
            return string;
        }
        cursor.moveToFirst();
        int n2 = cursor.getColumnIndex("value");
        if (n2 > 0) {
            string = cursor.getString(n2);
        }
        if ((n2 = cursor.getColumnIndex("code")) > 0) {
            cursor.getInt(n2);
        }
        if ((n2 = cursor.getColumnIndex("expired")) > 0) {
            cursor.getLong(n2);
        }
        return string;
    }

    private boolean isMeizuSupport() {
        try {
            PackageManager packageManager = this.mContext.getPackageManager();
            if (packageManager != null && (packageManager = packageManager.resolveContentProvider("com.meizu.flyme.openidsdk", 0)) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LiteApiLogger.printStackTrace(exception);
        }
        return false;
    }
}

