/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ContentProviderClient;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;

@Keep
public class NubiaDeviceIDHelper {
    private static final String TAG = "NubiaDeviceIDHelper";
    private Context mContext;

    public NubiaDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public String getOAID() {
        String string = "";
        try {
            Object object = Uri.parse((String)"content://cn.nubia.identity/identity");
            if (Build.VERSION.SDK_INT > 17) {
                ContentProviderClient contentProviderClient = this.mContext.getContentResolver().acquireContentProviderClient(object);
                object = contentProviderClient.call("getOAID", null, null);
                if (Build.VERSION.SDK_INT >= 24) {
                    contentProviderClient.close();
                } else {
                    contentProviderClient.release();
                }
            } else {
                object = this.mContext.getContentResolver().call(object, "getOAID", null, null);
            }
            if (object != null) {
                int n2 = object.getInt("code", -1);
                if (n2 == 0) {
                    string = object.getString("id");
                }
                object = object.getString("message");
                LiteApiLogger.i(TAG, "getOAID oaid:" + string + "faledMsg:" + (String)object);
            }
        }
        catch (Exception exception) {
            LiteApiLogger.i(TAG, "getOAID fail");
            LiteApiLogger.printStackTraceOnly(exception);
        }
        return string;
    }
}

