/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.PackageManagerUtils;
import com.kwad.sdk.liteapi.oaid.interfaces.OppoIDInterface;
import java.security.MessageDigest;
import java.util.concurrent.LinkedBlockingQueue;

@Keep
public class OppoDeviceIDHelper {
    private static final String TAG = "OppoDeviceIDHelper";
    private Context mContext;
    private final LinkedBlockingQueue<IBinder> mLinkedBlockingQueue = new LinkedBlockingQueue(1);
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName object, IBinder iBinder) {
            LiteApiLogger.i(OppoDeviceIDHelper.TAG, "onServiceConnected");
            try {
                OppoDeviceIDHelper.this.mLinkedBlockingQueue.put(iBinder);
                return;
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                LiteApiLogger.printStackTrace(interruptedException);
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }
    };

    public OppoDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public String getOAID() {
        String string;
        block7: {
            string = "";
            try {
                Intent intent = new Intent();
                intent.setComponent(new ComponentName("com.heytap.openid", "com.heytap.openid.IdentifyService"));
                intent.setAction("action.com.heytap.openid.OPEN_ID_SERVICE");
                boolean bl2 = this.mContext.bindService(intent, this.serviceConnection, 1);
                LiteApiLogger.i(TAG, "getOAID isBin=" + bl2);
                if (!bl2) break block7;
                try {
                    Object object = this.mLinkedBlockingQueue.take();
                    object = new OppoIDInterface.a((IBinder)object);
                    string = object.getSerID(this.mContext.getPackageName(), this.getSign(), "OUID");
                    LiteApiLogger.i(TAG, "getOAID oaid" + string);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    LiteApiLogger.printStackTrace(exception);
                }
                finally {
                    this.mContext.unbindService(this.serviceConnection);
                }
            }
            catch (Exception exception) {
                LiteApiLogger.i(TAG, "getOAID service not found");
                LiteApiLogger.printStackTraceOnly(exception);
            }
        }
        return string;
    }

    private String getSign() {
        String string = null;
        try {
            PackageInfo objectArray = PackageManagerUtils.getPackageInfo(this.mContext, this.mContext.getPackageName(), 64);
            if (objectArray == null) {
                return null;
            }
            Signature[] exception2 = objectArray.signatures;
            if (objectArray.signatures != null && exception2.length > 0) {
                byte[] byArray = exception2[0].toByteArray();
                Object object = MessageDigest.getInstance("SHA1");
                byte[] byArray2 = ((MessageDigest)object).digest(byArray);
                object = new StringBuilder();
                byte[] byArray3 = byArray2;
                int n2 = byArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    byte by2 = byArray3[i2];
                    ((StringBuilder)object).append(Integer.toHexString(by2 & 0xFF | 0x100).substring(1, 3));
                }
                string = ((StringBuilder)object).toString();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LiteApiLogger.printStackTrace(exception);
        }
        return string;
    }

    private boolean isSupportOppo() {
        try {
            String string = "com.heytap.openid";
            string = PackageManagerUtils.getPackageInfo(this.mContext, string, 0);
            if (string == null) {
                return false;
            }
            long l2 = Build.VERSION.SDK_INT >= 28 ? string.getLongVersionCode() : (long)((PackageInfo)string).versionCode;
            if (l2 >= 1L) {
                return true;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LiteApiLogger.printStackTrace(exception);
        }
        return false;
    }
}

