/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.oaid.helpers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.oaid.interfaces.ZTEIDInterface;
import java.util.concurrent.LinkedBlockingQueue;

@Keep
public class ZTEDeviceIDHelper {
    private static final String TAG = "ZTEDeviceIDHelper";
    public Context mContext;
    private final LinkedBlockingQueue<IBinder> mLinkedBlockingQueue = new LinkedBlockingQueue(1);
    private ServiceConnection serviceConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName object, IBinder iBinder) {
            try {
                LiteApiLogger.i(ZTEDeviceIDHelper.TAG, "onServiceConnected");
                ZTEDeviceIDHelper.this.mLinkedBlockingQueue.put(iBinder);
                return;
            }
            catch (Exception exception) {
                object = exception;
                LiteApiLogger.printStackTrace(exception);
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }
    };

    public ZTEDeviceIDHelper(Context context) {
        this.mContext = context;
    }

    public String getOAID() {
        String string;
        block7: {
            string = "";
            try {
                Intent intent = new Intent();
                intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaIdService");
                intent.setAction("com.bun.msa.action.bindto.service");
                intent.putExtra("com.bun.msa.param.pkgname", this.mContext.getPackageName());
                boolean bl2 = this.mContext.bindService(intent, this.serviceConnection, 1);
                LiteApiLogger.i(TAG, "getOAID isBind=" + bl2);
                if (!bl2) break block7;
                try {
                    Object object = this.mLinkedBlockingQueue.take();
                    object = new ZTEIDInterface.a((IBinder)object);
                    string = object.getOAID();
                    LiteApiLogger.i(TAG, "getOAID oaid:" + string);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    LiteApiLogger.printStackTrace(exception);
                }
                finally {
                    this.mContext.unbindService(this.serviceConnection);
                }
            }
            catch (Exception exception) {
                LiteApiLogger.i(TAG, "getOAID hw service not found");
                LiteApiLogger.printStackTrace(exception);
            }
        }
        return string;
    }

    private void startMsaklServer(String object) {
        Intent intent = new Intent();
        intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaKlService");
        intent.setAction("com.bun.msa.action.start.service");
        intent.putExtra("com.bun.msa.param.pkgname", (String)object);
        try {
            intent.putExtra("com.bun.msa.param.runinset", true);
            this.mContext.startService(intent);
            return;
        }
        catch (Exception exception) {
            object = exception;
            LiteApiLogger.printStackTrace(exception);
            return;
        }
    }
}

