/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.report;

import android.content.Context;
import android.support.annotation.Keep;
import com.kwad.sdk.api.core.RequestParamsUtils;
import com.kwad.sdk.api.core.TLSConnectionUtils;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.encrypt.LiteEncryptHelper;
import com.kwad.sdk.liteapi.report.LiteApiReportRequest;
import com.kwad.sdk.liteapi.report.LiteApiReportResponse;
import com.kwad.sdk.liteapi.report.LiteJsonUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

@Keep
class LiteReportHttp {
    private static final String TAG = "LiteReportHttp";
    private static final int CONNECTION_TIME_OUT = 10000;
    private static final int READ_WRITE_TIME_OUT = 30000;
    private static final int MAX_REDIRECTS = 21;
    private final String mUrl;
    private int currentNum;
    private String mCurrentUrl;

    LiteReportHttp(String string) {
        this.mCurrentUrl = this.mUrl = string;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void request(Context object, LiteApiReportRequest object2, a a2) {
        void var3_6;
        LiteApiReportResponse liteApiReportResponse;
        HttpURLConnection httpURLConnection = null;
        LiteApiLogger.w(TAG, "request start ");
        Object object3 = this.buildHeader();
        String string = this.buildBody((Context)object, (LiteApiReportRequest)((Object)liteApiReportResponse), (Map<String, String>)object3);
        LiteApiLogger.w(TAG, "request start bodyParams: " + string);
        LiteApiLogger.w(TAG, "request start mCurrentUrl: " + this.mCurrentUrl);
        LiteReportHttp liteReportHttp = this;
        httpURLConnection = liteReportHttp.createUrlConnection(liteReportHttp.mCurrentUrl);
        this.setConnectionHeader(httpURLConnection, (Map<String, String>)object3);
        httpURLConnection.connect();
        object3 = new DataOutputStream(httpURLConnection.getOutputStream());
        ((FilterOutputStream)object3).write(string.getBytes());
        int n2 = httpURLConnection.getResponseCode();
        LiteApiLogger.w(TAG, "response responseCode :  " + n2);
        if (n2 == 200) {
            String string2 = LiteReportHttp.inputStream2String(httpURLConnection.getInputStream());
            LiteApiLogger.w(TAG, "response resultStr :  " + string2);
            liteApiReportResponse = new LiteApiReportResponse();
            assert (string2 != null);
            JSONObject jSONObject = new JSONObject(string2);
            liteApiReportResponse.parseJson(jSONObject);
            var3_6.a(liteApiReportResponse);
        } else {
            if (n2 / 100 != 3) throw new RuntimeException("response code = " + n2);
            if (this.currentNum < 21) {
                this.mCurrentUrl = httpURLConnection.getHeaderField("Location");
                ++this.currentNum;
                this.request((Context)object, (LiteApiReportRequest)((Object)liteApiReportResponse), (a)var3_6);
            }
        }
        if (httpURLConnection == null) return;
        try {
            httpURLConnection.disconnect();
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Exception exception) {
            try {
                LiteApiLogger.w(TAG, "request Exception e: " + exception.getMessage());
                exception.printStackTrace();
                var3_6.b(exception);
                if (httpURLConnection == null) return;
            }
            catch (Throwable throwable) {
                if (httpURLConnection == null) throw throwable;
                try {
                    httpURLConnection.disconnect();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                httpURLConnection.disconnect();
                return;
            }
            catch (Exception exception3) {
                return;
            }
        }
    }

    /*
     * Loose catch block
     */
    private static String inputStream2String(InputStream object) {
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream;
        block20: {
            int n2;
            byteArrayOutputStream = null;
            object2 = new byte[1024];
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = ((InputStream)object).read((byte[])object2)) != -1) {
                byteArrayOutputStream.write((byte[])object2, 0, n2);
            }
            object2 = byteArrayOutputStream.toString();
            if (object == null) break block20;
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return object2;
        catch (IOException iOException) {
            block21: {
                try {
                    object2 = iOException;
                    iOException.printStackTrace();
                    if (object == null) break block21;
                }
                catch (Throwable throwable) {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException2) {
                            object = iOException2;
                            iOException2.printStackTrace();
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException3) {
                            object = iOException3;
                            iOException3.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException4) {
                    object2 = iOException4;
                    iOException4.printStackTrace();
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException5) {
                    object2 = iOException5;
                    iOException5.printStackTrace();
                }
            }
        }
        return null;
    }

    private void setConnectionHeader(HttpURLConnection httpURLConnection, Map<String, String> object) {
        if (object != null && httpURLConnection != null) {
            for (Map.Entry entry : object.entrySet()) {
                httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private String buildBody(Context context, LiteApiReportRequest liteApiReportRequest, Map<String, String> map) {
        Object object = liteApiReportRequest.toJson();
        object = object.toString();
        if (this.disableEncrypt()) {
            map.put("x-ksad-ignore-decrypt", "true");
            return object;
        }
        LiteEncryptHelper.addHeaderParams(context, map);
        JSONObject jSONObject = new JSONObject();
        LiteJsonUtil.putValue(jSONObject, "version", liteApiReportRequest.sdkApiVersion);
        LiteJsonUtil.putValue(jSONObject, "appId", liteApiReportRequest.getAppId());
        LiteJsonUtil.putValue(jSONObject, "message", LiteEncryptHelper.getRequestMessage(context, (String)object));
        LiteEncryptHelper.sigRequest(context, this.mUrl, map, jSONObject.toString());
        return jSONObject.toString();
    }

    private boolean disableEncrypt() {
        return false;
    }

    private Map<String, String> buildHeader() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Accept-Language", "zh-CN");
        hashMap.put("Connection", "keep-alive");
        hashMap.put("Charset", "UTF-8");
        hashMap.put("Content-Type", "application/json; charset=UTF-8");
        hashMap.put("User-Agent", RequestParamsUtils.getUserAgent());
        return hashMap;
    }

    private HttpURLConnection createUrlConnection(String object) {
        object = (HttpURLConnection)new URL((String)object).openConnection();
        TLSConnectionUtils.wrapHttpURLConnection((URLConnection)object);
        ((URLConnection)object).setConnectTimeout(10000);
        ((URLConnection)object).setReadTimeout(30000);
        ((URLConnection)object).setUseCaches(false);
        ((URLConnection)object).setDoInput(true);
        ((HttpURLConnection)object).setRequestMethod("POST");
        ((URLConnection)object).setDoOutput(true);
        ((HttpURLConnection)object).setInstanceFollowRedirects(true);
        return object;
    }

    public static interface a {
        public void a(LiteApiReportResponse var1);

        public void b(Exception var1);
    }
}

