/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.report;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.Signature;
import android.os.FileUtils;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.PackageManagerUtils;
import com.kwad.sdk.liteapi.utils.LiteMd5Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

@Keep
public class LiteSignatureUtils {
    private static String TAG = "LiteSignatureUtils";
    private static final int BUFFER_SIZE = 4096;
    public static Signature[] currentSignatures = new Signature[0];

    @Nullable
    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static Signature[] getSignatures(Context context) {
        if (currentSignatures != null && currentSignatures.length > 0) {
            return currentSignatures;
        }
        Context context2 = context;
        context = PackageManagerUtils.getPackageInfo(context2, context2.getPackageName(), 64);
        if (context != null) {
            currentSignatures = context.signatures;
        }
        return currentSignatures;
    }

    @Nullable
    public static Signature[] getSignatures(Context signatureArray, String string) {
        if ((signatureArray = LiteSignatureUtils.getArchiveSignatures((Context)signatureArray, string)) == null && (signatureArray = LiteSignatureUtils.getArchiveSignatures(string, false)) == null) {
            signatureArray = LiteSignatureUtils.getArchiveSignatures(string, true);
        }
        return signatureArray;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private static Signature[] getArchiveSignatures(Context context, String string) {
        if ((context = context.getPackageManager().getPackageArchiveInfo(string, 64)) == null) {
            return null;
        }
        return context.signatures;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    static Signature[] getArchiveSignatures(String var0, boolean var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Certificate[] loadCertificates(JarFile jarFile, JarEntry jarEntry, byte[] objectArray) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            while (((InputStream)bufferedInputStream).read((byte[])objectArray, 0, objectArray.length) != -1) {
            }
            objectArray = jarEntry != null ? jarEntry.getCertificates() : null;
        }
        catch (IOException | RuntimeException exception) {
            try {
                LiteApiLogger.w(TAG, "Exception reading " + jarEntry.getName() + " in " + jarFile.getName());
                LiteApiLogger.w(TAG, exception);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            FileUtils.closeQuietly((AutoCloseable)bufferedInputStream);
            return null;
        }
        FileUtils.closeQuietly((AutoCloseable)bufferedInputStream);
        return objectArray;
    }

    public static boolean isSignaturesSame(Signature[] object, Signature[] signatureArray) {
        if (object == null || signatureArray == null) {
            return false;
        }
        if (((Signature[])object).length != signatureArray.length) {
            return false;
        }
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, object);
        object = new HashSet();
        Collections.addAll(object, signatureArray);
        return hashSet.equals(object);
    }

    public static boolean isSignaturesSame(String string, Signature[] signatureArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (signatureArray == null) {
            return false;
        }
        for (Object object : signatureArray) {
            if (!(object = object.toCharsString().toLowerCase()).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static String getSignMd5Str(Context object) {
        try {
            object = LiteSignatureUtils.getSignatures((Context)object);
            if (object == null || ((Signature[])object).length <= 0) {
                return "";
            }
            object = object[0];
            object = LiteMd5Util.md5ForByte(object.toByteArray());
            return object;
        }
        catch (Exception exception) {
            LiteApiLogger.w(TAG, exception);
            return "";
        }
    }
}

