/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.utils;

import android.support.annotation.Keep;
import com.kwad.sdk.liteapi.LiteApiLogger;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.zip.ZipFile;

@Keep
public class LiteCloseableUtil {
    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void closeQuietly(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray == null) {
            return;
        }
        for (Closeable closeable : closeableArray) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                LiteApiLogger.printStackTrace(throwable);
            }
        }
    }
}

