/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.liteapi.utils;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.kwad.sdk.liteapi.LiteApiLogger;
import com.kwad.sdk.liteapi.utils.LiteCloseableUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;

@Keep
public class LiteMd5Util {
    static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @NonNull
    public static String md5(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return LiteMd5Util.md5ForByte(string.getBytes());
    }

    public static String md5ForByte(byte[] byArray) {
        try {
            Object object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(byArray);
            byArray = ((MessageDigest)object).digest();
            object = new StringBuilder();
            byte[] byArray2 = byArray;
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = byArray2[i2];
                int n4 = n3;
                n4 = n3;
                if (n3 < 0) {
                    n4 += 256;
                }
                if (n4 < 16) {
                    ((StringBuilder)object).append("0");
                }
                ((StringBuilder)object).append(Integer.toHexString(n4));
            }
            return ((StringBuilder)object).toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String sha1(String object) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(((String)object).getBytes());
            byte[] byArray = messageDigest.digest();
            object = byArray;
            return LiteMd5Util.toHexString(byArray, 0, ((Object)object).length);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LiteApiLogger.printStackTrace(exception);
            return "";
        }
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = new char[n3 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = byArray[i2 + n2] & 0xFF;
            cArray[n4++] = HEX_CHARS[n5 >> 4];
            cArray[n4++] = HEX_CHARS[n5 & 0xF];
        }
        return new String(cArray, 0, n3 * 2);
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by2 : byArray) {
            stringBuffer.append(String.format("%02x", by2));
        }
        return stringBuffer.toString();
    }

    public static String getFileMD5Digest(File object) {
        if (object == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            fileInputStream = new FileInputStream((File)object);
            object = new byte[4096];
            while ((n2 = fileInputStream.read((byte[])object)) != -1) {
                messageDigest.update((byte[])object, 0, n2);
            }
            object = LiteMd5Util.toHexString(messageDigest.digest());
            LiteCloseableUtil.closeQuietly((Closeable)fileInputStream);
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LiteApiLogger.printStackTraceOnly(exception);
            return null;
        }
        finally {
            LiteCloseableUtil.closeQuietly(fileInputStream);
        }
    }

    public static String getFileMD5Digest(String string) {
        return LiteMd5Util.getFileMD5Digest(new File(string));
    }

    public static String getPartOfFileMD5Digest(String object, long l2, long l3) {
        if (((File)(object = new File((String)object))).length() > 0L) {
            String string;
            RandomAccessFile randomAccessFile = null;
            try {
                int n2;
                randomAccessFile = new RandomAccessFile((File)object, "r");
                long l4 = 0L;
                if (l2 >= 0L && l2 < ((File)object).length()) {
                    l4 = l2;
                }
                randomAccessFile.seek(l4);
                int n3 = 0;
                byte[] byArray = new byte[4096];
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                while ((long)n3 < l3 && (n2 = randomAccessFile.read(byArray)) != -1) {
                    if (n2 > 0 && (long)(n3 + n2) > l3) {
                        n2 = (int)(l3 - (long)n3);
                        messageDigest.update(byArray, 0, n2);
                        n3 += n2;
                        continue;
                    }
                    messageDigest.update(byArray, 0, n2);
                    n3 += n2;
                }
                string = LiteMd5Util.toHexString(messageDigest.digest());
            }
            catch (Exception exception) {
                try {
                    Exception exception2 = exception;
                    LiteApiLogger.printStackTrace(exception);
                }
                catch (Throwable throwable) {
                    LiteCloseableUtil.closeQuietly(randomAccessFile);
                    throw throwable;
                }
                LiteCloseableUtil.closeQuietly((Closeable)randomAccessFile);
            }
            LiteCloseableUtil.closeQuietly((Closeable)randomAccessFile);
            return string;
        }
        return null;
    }
}

