/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.oaid;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.miitmdid.interfaces.IIdentifierListener;
import com.bun.miitmdid.interfaces.IdSupplier;

@Keep
public class OADIDSDKHelper25 {
    private static final String TAG = "KSAdSDK";
    private static final String SUB_TAG = "OADIDSDKHelper25:";
    private static boolean mIsRequestIng;
    private static boolean sGetOaidFail;

    public static void getOAId(Context context, a a2) {
        if (context == null || sGetOaidFail) {
            return;
        }
        if (!OADIDSDKHelper25.isSupport()) {
            sGetOaidFail = true;
            return;
        }
        if (mIsRequestIng) {
            return;
        }
        mIsRequestIng = true;
        try {
            long l2 = System.currentTimeMillis();
            int n2 = MdidSdkHelper.InitSdk((Context)context.getApplicationContext(), (boolean)true, (IIdentifierListener)new IIdentifierListener25(l2, a2));
            long l3 = System.currentTimeMillis() - l2;
            Log.d((String)TAG, (String)("OADIDSDKHelper25:sdk init time=" + l3 + "--result=" + n2));
            return;
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)"OADIDSDKHelper25:oaid sdk not find ");
            mIsRequestIng = false;
            sGetOaidFail = true;
            return;
        }
    }

    public static boolean isSupport() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        try {
            IIdentifierListener iIdentifierListener = new IIdentifierListener(){

                public void OnSupport(boolean bl2, IdSupplier idSupplier) {
                }
            };
            iIdentifierListener.OnSupport(true, null);
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)"OADIDSDKHelper25:isSupport oaid sdk not find ");
            return false;
        }
        try {
            Class.forName("com.bun.miitmdid.core.MdidSdkHelper", false, OADIDSDKHelper25.class.getClassLoader());
        }
        catch (Throwable throwable) {
            Log.d((String)TAG, (String)"OADIDSDKHelper25:com.bun.miitmdid.core.MdidSdkHelper oaid sdk not find ");
            return false;
        }
        return true;
    }

    static {
        sGetOaidFail = false;
    }

    public static interface a {
        @WorkerThread
        public void OnOAIDValid(String var1);
    }

    @Keep
    static class IIdentifierListener25
    implements IIdentifierListener {
        private final long mStartTime;
        private final a mOaidListener;

        public IIdentifierListener25(long l2, a a2) {
            this.mStartTime = l2;
            this.mOaidListener = a2;
        }

        public void OnSupport(boolean bl2, IdSupplier idSupplier) {
            long l2 = System.currentTimeMillis() - this.mStartTime;
            if (idSupplier != null) {
                String string2 = idSupplier.getOAID();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    Log.d((String)OADIDSDKHelper25.TAG, (String)("OADIDSDKHelper25:oaid time=" + l2 + "--OAID:" + string2));
                    this.mOaidListener.OnOAIDValid(string2);
                } else {
                    sGetOaidFail = true;
                }
            }
            mIsRequestIng = false;
        }
    }
}

