/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.utils;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.kwad.sdk.utils.z;

public final class AbiUtil {
    private static Abi aYo;

    public static String cp(Context context) {
        if (AbiUtil.isArm64(context)) {
            return "arm64-v8a";
        }
        return "armeabi-v7a";
    }

    public static boolean isArm64(Context context) {
        return AbiUtil.cq(context) == Abi.ARM64_V8A;
    }

    private static Abi cq(Context context) {
        if (aYo != null) {
            return aYo;
        }
        if (Build.VERSION.SDK_INT < 21) {
            aYo = Abi.ARMEABI_V7A;
        } else if (Build.VERSION.SDK_INT >= 23) {
            aYo = Process.is64Bit() ? Abi.ARM64_V8A : Abi.ARMEABI_V7A;
        } else if (Build.VERSION.SDK_INT >= 21) {
            try {
                Object t2 = z.a("dalvik.system.VMRuntime", "getRuntime", new Object[0]);
                boolean bl2 = (Boolean)z.callMethod(t2, "is64Bit", new Object[0]);
                aYo = bl2 ? Abi.ARM64_V8A : Abi.ARMEABI_V7A;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                try {
                    aYo = context.getApplicationInfo().nativeLibraryDir.contains("arm64") ? Abi.ARM64_V8A : Abi.UNKNOWN;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throwable3.printStackTrace();
                    aYo = Abi.UNKNOWN;
                }
            }
        }
        return aYo;
    }

    public static enum Abi {
        UNKNOWN,
        ARMEABI_V7A,
        ARM64_V8A;

    }
}

