/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.utils;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final long maxSize;

    public LruHashMap(long l2) {
        super((int)Math.ceil((float)l2 / 0.75f) + 1, 0.75f, true);
        this.maxSize = l2;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return (long)this.size() > this.maxSize;
    }
}

