/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import android.view.View;
import com.kwad.sdk.R;

public class DividerView
extends View {
    public static int ORIENTATION_HORIZONTAL = 0;
    public static int ORIENTATION_VERTICAL = 1;
    private Paint mPaint;
    private int orientation;
    private int bcU;

    public DividerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n2;
        int n3;
        int n4;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.ksad_DividerView, 0, 0);
        try {
            n4 = typedArray.getDimensionPixelSize(R.styleable.ksad_DividerView_ksad_dashGap, 5);
            n3 = typedArray.getDimensionPixelSize(R.styleable.ksad_DividerView_ksad_dashLength, 5);
            n2 = typedArray.getDimensionPixelSize(R.styleable.ksad_DividerView_ksad_dashThickness, 3);
            this.bcU = typedArray.getColor(R.styleable.ksad_DividerView_ksad_color, -16777216);
            this.orientation = typedArray.getInt(R.styleable.ksad_DividerView_ksad_orientation, ORIENTATION_HORIZONTAL);
        }
        finally {
            typedArray.recycle();
        }
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.bcU);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)n2);
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{n3, n4}, 0.0f));
    }

    public DividerView(Context context) {
        this(context, null);
    }

    protected void onDraw(Canvas canvas) {
        if (this.orientation == ORIENTATION_HORIZONTAL) {
            float f2 = (float)this.getHeight() * 0.5f;
            canvas.drawLine(0.0f, f2, (float)this.getWidth(), f2, this.mPaint);
            return;
        }
        float f3 = (float)this.getWidth() * 0.5f;
        canvas.drawLine(f3, 0.0f, f3, (float)this.getHeight(), this.mPaint);
    }

    public void setDividerColor(int n2) {
        this.bcU = n2;
        this.mPaint.setColor(this.bcU);
        this.postInvalidate();
    }
}

