/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.kwad.sdk.c.a.a;

public class DownloadProgressBar
extends View {
    private Path mPath;
    Paint bcV;
    Paint bcW;
    Paint bcX;
    private RectF mRectF;
    private String bcY;
    private float bcZ;
    private Rect bda;
    private LinearGradient bdb;
    private LinearGradient bdc;
    private LinearGradient bdd;
    private long mStartTime;
    private Matrix mMatrix;
    private Runnable bde = new Runnable(){

        @Override
        public final void run() {
            DownloadProgressBar.this.invalidate();
            if (DownloadProgressBar.this.getWindowVisibility() == 0) {
                DownloadProgressBar.this.postDelayed(this, 34L);
            }
        }
    };

    public DownloadProgressBar(Context context) {
        this(context, null, 0);
    }

    public DownloadProgressBar(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DownloadProgressBar(Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.bcV = new Paint(1);
        this.bcW = new Paint(1);
        this.mRectF = new RectF();
        this.bcX = new Paint(1);
        this.bcX.setTextSize((float)a.a(context, 16.0f));
        this.bcX.setColor(-1);
        this.bcX.setTextAlign(Paint.Align.CENTER);
        this.bda = new Rect();
        this.mMatrix = new Matrix();
        this.mPath = new Path();
    }

    public void setText(String string2) {
        this.bcY = string2;
        this.invalidate();
    }

    public void setProgress(float f2) {
        this.bcZ = f2;
        this.invalidate();
        if (f2 == 0.0f || f2 == 100.0f) {
            DownloadProgressBar downloadProgressBar = this;
            downloadProgressBar.removeCallbacks(downloadProgressBar.bde);
            return;
        }
        if (this.getWindowVisibility() == 0 && this.mStartTime == 0L) {
            DownloadProgressBar downloadProgressBar = this;
            downloadProgressBar.post(downloadProgressBar.bde);
        }
    }

    protected void onWindowVisibilityChanged(int n2) {
        super.onWindowVisibilityChanged(n2);
        if (n2 == 0) {
            if (this.bcZ > 0.0f && this.bcZ < 100.0f) {
                this.mStartTime = SystemClock.elapsedRealtime();
                DownloadProgressBar downloadProgressBar = this;
                downloadProgressBar.post(downloadProgressBar.bde);
                return;
            }
        } else {
            DownloadProgressBar downloadProgressBar = this;
            downloadProgressBar.removeCallbacks(downloadProgressBar.bde);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        DownloadProgressBar downloadProgressBar = this;
        downloadProgressBar.removeCallbacks(downloadProgressBar.bde);
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        this.bdb = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), 0.0f, new int[]{1291525714, 1291569420}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        this.bdc = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), 0.0f, new int[]{-319918, -276212}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        this.bcV.setShader((Shader)this.bdb);
        this.bdd = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), 0.0f, new int[]{16501004, -276212}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        this.bcW.setShader((Shader)this.bdd);
        this.mRectF.set(0.0f, 0.0f, (float)n2, (float)n3);
        this.mPath.reset();
        this.mPath.addRoundRect(this.mRectF, (float)n2 / 2.0f, (float)n2 / 2.0f, Path.Direction.CW);
    }

    protected void onVisibilityChanged(@NonNull View view, int n2) {
        super.onVisibilityChanged(view, n2);
    }

    protected void onDraw(Canvas canvas) {
        float f2;
        super.onDraw(canvas);
        canvas.clipPath(this.mPath);
        this.bcV.setShader((Shader)this.bdb);
        canvas.drawRect(this.mRectF, this.bcV);
        this.bcV.setShader((Shader)this.bdc);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth() * this.bcZ / 100.0f, (float)this.getHeight(), this.bcV);
        if (this.bcZ > 0.0f && this.bcZ < 100.0f) {
            long l2 = (SystemClock.elapsedRealtime() - this.mStartTime) % 2500L;
            float f3 = l2 >= 1500L ? 0.0f : (float)l2 / 1500.0f;
            this.mMatrix.reset();
            this.mMatrix.setScale(1.0f, f3);
            this.bdd.setLocalMatrix(this.mMatrix);
            this.bcW.setShader((Shader)this.bdd);
            float f4 = (float)this.getWidth() * this.bcZ / 100.0f * f3;
            canvas.drawRect(0.0f, 0.0f, f4, (float)this.getHeight(), this.bcW);
            f2 = l2 <= 500L || l2 > 1500L ? 0.0f : (float)(l2 - 500L) / 1000.0f;
            f2 = (float)this.getWidth() * this.bcZ / 100.0f * f2;
            this.mMatrix.reset();
            this.mMatrix.setScale(1.0f, f3);
            this.bdd.setLocalMatrix(this.mMatrix);
            this.bcW.setShader((Shader)this.bdd);
            canvas.drawRect(0.0f, 0.0f, f2, (float)this.getHeight(), this.bcW);
        }
        if (this.bcY != null) {
            this.bcX.getTextBounds(this.bcY, 0, this.bcY.length(), this.bda);
            f2 = (float)(this.bda.top + this.bda.bottom) / 2.0f;
            canvas.drawText(this.bcY, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f - f2, this.bcX);
        }
    }
}

