/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.kwad.sdk.R;
import com.kwad.sdk.service.ServiceProvider;
import java.util.Arrays;

public final class j {
    public float[] radiusArray = new float[8];
    private float mRadius;
    private Path mPath;
    private Paint mPaint;
    private RectF mRectF;
    private boolean mClipBackground;
    @NonNull
    private a mCornerConf;

    public j() {
        this.mCornerConf = new a();
    }

    public j(a a2) {
        this.mCornerConf = a2;
    }

    public final void initAttrs(Context context, @Nullable AttributeSet attributeSet) {
        try {
            if (attributeSet != null) {
                int n2 = R.attr.ksad_radius;
                int n3 = R.attr.ksad_clipBackground;
                int[] nArray = new int[]{n2, n3};
                Arrays.sort(nArray);
                context = context.obtainStyledAttributes(attributeSet, nArray);
                this.mRadius = context.getDimensionPixelOffset(Arrays.binarySearch(nArray, n2), 0);
                this.mClipBackground = context.getBoolean(Arrays.binarySearch(nArray, n3), true);
                context.recycle();
            }
            this.mPath = new Path();
            this.mPaint = new Paint(1);
            this.mRectF = new RectF();
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ServiceProvider.reportSdkCaughtException(throwable);
            return;
        }
    }

    public final void setRadius(float f2) {
        this.mRadius = f2;
    }

    public final void setRadius(float[] fArray) {
        this.radiusArray = fArray;
    }

    public final void onSizeChanged(int n2, int n3) {
        this.mRectF.set(0.0f, 0.0f, (float)n2, (float)n3);
    }

    public final void beforeDraw(Canvas canvas) {
        if (!this.mClipBackground) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28) {
            canvas.saveLayer(this.mRectF, null, 31);
            return;
        }
        canvas.save();
        canvas.clipPath(this.getPath());
    }

    public final void afterDraw(Canvas canvas) {
        if (!this.mClipBackground) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28) {
            canvas.drawPath(this.getPath(), this.mPaint);
        }
        canvas.restore();
    }

    public final void beforeDispatchDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 28) {
            canvas.save();
            canvas.clipPath(this.getPath());
            return;
        }
        canvas.saveLayer(this.mRectF, null, 31);
    }

    public final void afterDispatchDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT < 28) {
            canvas.drawPath(this.getPath(), this.mPaint);
        }
        canvas.restore();
    }

    private float[] getRadius() {
        this.radiusArray[0] = this.mCornerConf.isLeftTop() ? this.mRadius : 0.0f;
        this.radiusArray[1] = this.mCornerConf.isLeftTop() ? this.mRadius : 0.0f;
        this.radiusArray[2] = this.mCornerConf.isTopRight() ? this.mRadius : 0.0f;
        this.radiusArray[3] = this.mCornerConf.isTopRight() ? this.mRadius : 0.0f;
        this.radiusArray[4] = this.mCornerConf.isRightBottom() ? this.mRadius : 0.0f;
        this.radiusArray[5] = this.mCornerConf.isRightBottom() ? this.mRadius : 0.0f;
        this.radiusArray[6] = this.mCornerConf.isBottomLeft() ? this.mRadius : 0.0f;
        this.radiusArray[7] = this.mCornerConf.isBottomLeft() ? this.mRadius : 0.0f;
        return this.radiusArray;
    }

    @NonNull
    public final a getCornerConf() {
        return this.mCornerConf;
    }

    private Path getPath() {
        try {
            this.mPath.reset();
        }
        catch (Exception exception) {}
        float[] fArray = this.mRadius == 0.0f ? this.radiusArray : this.getRadius();
        this.mPath.addRoundRect(this.mRectF, fArray, Path.Direction.CW);
        return this.mPath;
    }

    public static final class a {
        private boolean leftTop = true;
        private boolean topRight = true;
        private boolean rightBottom = true;
        private boolean bottomLeft = true;

        public final boolean isLeftTop() {
            return this.leftTop;
        }

        public final a cp(boolean bl2) {
            this.leftTop = bl2;
            return this;
        }

        public final boolean isTopRight() {
            return this.topRight;
        }

        public final a cq(boolean bl2) {
            this.topRight = bl2;
            return this;
        }

        public final boolean isRightBottom() {
            return this.rightBottom;
        }

        public final a cr(boolean bl2) {
            this.rightBottom = bl2;
            return this;
        }

        public final boolean isBottomLeft() {
            return this.bottomLeft;
        }

        public final a cs(boolean bl2) {
            this.bottomLeft = bl2;
            return this;
        }

        public final void setAllCorner(boolean bl2) {
            this.leftTop = bl2;
            this.topRight = bl2;
            this.rightBottom = bl2;
            this.bottomLeft = bl2;
        }
    }
}

