/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.adclient.kscommerciallogger.snapshot;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.LruCache;
import com.kwai.adclient.kscommerciallogger.snapshot.a;
import com.kwai.adclient.kscommerciallogger.snapshot.c;
import com.kwai.adclient.kscommerciallogger.snapshot.d;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;

public enum SegmentManager {
    Instance;

    private LruCache<String, Set<c>> mSnapshots;
    private boolean isDebug = false;
    private boolean hasInit = false;
    private long lastAutoClearTime;
    private static final int expiredThresholds = 900000;

    public final synchronized void init(int n2, boolean bl2) {
        if (!this.hasInit) {
            this.isDebug = bl2;
            if (n2 > 0) {
                this.mSnapshots = new LruCache<String, Set<c>>(n2){

                    private static int f(Set<c> set) {
                        return set.size();
                    }

                    protected final /* synthetic */ int sizeOf(Object object, Object object2) {
                        return 1.f((Set)object2);
                    }
                };
            }
            this.hasInit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final c loadSegment(@NonNull String string2, @NonNull String string3, int n2) {
        if (this.mSnapshots == null) {
            if (!this.hasInit && this.isDebug) {
                throw new IllegalStateException("you need init first");
            }
            return new a("empty");
        }
        SegmentManager segmentManager = this;
        synchronized (segmentManager) {
            Set set = (Set)this.mSnapshots.get((Object)string2);
            if (set != null) {
                for (Object object : set) {
                    if (!((c)object).getName().equals(string3)) continue;
                    return object;
                }
            }
            c c2 = new c(string3, n2);
            if (set != null) {
                this.mSnapshots.remove((Object)string2);
                set.add(c2);
                this.mSnapshots.put((Object)string2, (Object)set);
            } else {
                Object object;
                object = new LinkedHashSet<Object>();
                ((HashSet)object).add(c2);
                this.mSnapshots.put((Object)string2, object);
            }
            this.autoClear();
            return c2;
        }
    }

    public final c loadSegment(@NonNull String string2, @NonNull String string3) {
        return this.loadSegment(string2, string3, 10);
    }

    public final d loadSpan(@NonNull String string2, @NonNull String string3) {
        return this.loadSpan(string2, string3, "span");
    }

    public final d loadSpan(@NonNull String object, @NonNull String string2, @NonNull String string3) {
        object = this.loadSegment((String)object, string2);
        return ((c)object).hP(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBySessionId(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2) || this.mSnapshots == null) {
            return;
        }
        SegmentManager segmentManager = this;
        synchronized (segmentManager) {
            this.mSnapshots.remove((Object)string2);
            this.autoClear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void clearBySegment(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2) || this.mSnapshots == null) {
            return;
        }
        SegmentManager segmentManager = this;
        synchronized (segmentManager) {
            for (Map.Entry entry : this.mSnapshots.snapshot().entrySet()) {
                this.clearBySegment((String)entry.getKey(), string2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBySegment(String string2, String object) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)object) || this.mSnapshots == null) {
            return;
        }
        SegmentManager segmentManager = this;
        synchronized (segmentManager) {
            Set set = (Set)this.mSnapshots.get((Object)string2);
            object = new c((String)object);
            if (set != null && set.contains(object)) {
                this.mSnapshots.remove((Object)string2);
                set.remove(object);
                if (set.size() > 0) {
                    this.mSnapshots.put((Object)string2, (Object)set);
                }
            }
            this.autoClear();
            return;
        }
    }

    private void autoClear() {
        if (this.mSnapshots == null || this.mSnapshots.size() == 0 || System.currentTimeMillis() - this.lastAutoClearTime < 900000L) {
            return;
        }
        this.lastAutoClearTime = System.currentTimeMillis();
        for (Map.Entry entry : this.mSnapshots.snapshot().entrySet()) {
            String string2 = (String)entry.getKey();
            Set object = (Set)entry.getValue();
            if (object == null) continue;
            Iterator iterator = object.iterator();
            this.mSnapshots.remove((Object)string2);
            while (iterator.hasNext()) {
                c c2 = (c)iterator.next();
                if (this.lastAutoClearTime - c2.Tr() < 900000L) continue;
                iterator.remove();
            }
            if (object.size() <= 0) continue;
            this.mSnapshots.put((Object)string2, (Object)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSONArray loadInfoBySessionId(String string2) {
        JSONArray jSONArray = new JSONArray();
        if (this.mSnapshots == null || this.mSnapshots.size() == 0) {
            return jSONArray;
        }
        SegmentManager segmentManager = this;
        synchronized (segmentManager) {
            Object object = (Set)this.mSnapshots.get((Object)string2);
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    c c2 = (c)object.next();
                    jSONArray.put((Object)c2.hQ(string2));
                }
                this.mSnapshots.remove((Object)string2);
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSONArray justLoadInfoBySessionId(String string2) {
        JSONArray jSONArray = new JSONArray();
        if (this.mSnapshots == null || this.mSnapshots.size() == 0) {
            return jSONArray;
        }
        SegmentManager segmentManager = this;
        synchronized (segmentManager) {
            Object object = (Set)this.mSnapshots.get((Object)string2);
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    c c2 = (c)object.next();
                    jSONArray.put((Object)c2.hQ(string2));
                }
            }
        }
        return jSONArray;
    }

    public final synchronized int size() {
        if (this.mSnapshots == null) {
            return 0;
        }
        return this.mSnapshots.snapshot().size();
    }

    public final synchronized int segmentSize() {
        if (this.mSnapshots == null) {
            return 0;
        }
        return this.mSnapshots.size();
    }

    public final String loadSessionId() {
        return UUID.randomUUID().toString();
    }

    public final int cacheLimit() {
        if (this.mSnapshots == null) {
            return 0;
        }
        return this.mSnapshots.maxSize();
    }

    public final synchronized boolean isOverThreshold() {
        double d2;
        if (this.cacheLimit() <= 0 || this.segmentSize() == 0) {
            return false;
        }
        double d3 = BigDecimal.valueOf((float)this.segmentSize() / (float)this.cacheLimit()).setScale(2, RoundingMode.HALF_UP).doubleValue();
        return d2 >= 0.7;
    }

    public final synchronized Map.Entry<String, Integer> mostUsedSegmentInfo() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry entry : this.mSnapshots.snapshot().entrySet()) {
            for (c c2 : (Set)entry.getValue()) {
                Integer n2 = (Integer)hashMap.get(c2.getName());
                if (n2 == null) {
                    hashMap.put(c2.getName(), 1);
                    continue;
                }
                hashMap.put(c2.getName(), n2 + 1);
            }
        }
        ArrayList arrayList = new ArrayList(hashMap.entrySet());
        return Collections.max(arrayList, new Comparator<Map.Entry<String, Integer>>(){

            private static int a(Map.Entry<String, Integer> entry, Map.Entry<String, Integer> entry2) {
                return entry.getValue().compareTo(entry2.getValue());
            }

            @Override
            public final /* synthetic */ int compare(Object object, Object object2) {
                return 2.a((Map.Entry)object, (Map.Entry)object2);
            }
        });
    }
}

