package com.egame.unipaytest;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import java.text.SimpleDateFormat;
import java.util.Locale;

import cn.gundam.sdk.shell.even.SDKEventKey;
import cn.gundam.sdk.shell.even.SDKEventReceiver;
import cn.gundam.sdk.shell.even.Subscribe;
import cn.gundam.sdk.shell.exception.AliLackActivityException;
import cn.gundam.sdk.shell.exception.AliNotInitException;
import cn.gundam.sdk.shell.open.ParamInfo;
import cn.gundam.sdk.shell.open.UCOrientation;
import cn.gundam.sdk.shell.param.SDKParamKey;
import cn.gundam.sdk.shell.param.SDKParams;
import cn.uc.gamesdk.UCGameSdk;
import cn.uc.paysdk.face.commons.Response;
import cn.uc.paysdk.face.commons.SDKProtocolKeys;

public class MainActivity extends Activity {

    private String TAG = "ucgamesasdk";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        UCGameSdk.defaultSdk().registerSDKEventReceiver(receiver);

        findViewById(R.id.btnBilling).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                doPay();
            }
        });

        ucSdkInit();
    }

    private void ucSdkInit() {
        ParamInfo gameParamInfo = new ParamInfo();

        gameParamInfo.setGameId(556324);
        gameParamInfo.setOrientation(UCOrientation.PORTRAIT);

        SDKParams sdkParams = new SDKParams();
        sdkParams.put(SDKParamKey.GAME_PARAMS, gameParamInfo);
        // 如果游戏已经申请了权限，不想sdk主动请求权限，要通过SDKParamKey.GAME_HAD_REQUEST_PERMISSION参数告知九游sdk
        // true 游戏已经弹了，SDK不需要弹出权限申请窗
        // false 游戏没有弹，SDK可以按需弹出权限申请窗
        sdkParams.put(SDKParamKey.GAME_HAD_REQUEST_PERMISSION, false);


        try {
            //初始化SDK
            UCGameSdk.defaultSdk().initSdk(this, sdkParams);
        } catch (AliLackActivityException e) {
            e.printStackTrace();
        }
    }

    public void doPay() {

        SDKParams sdkParams = new SDKParams();
        sdkParams.put(SDKProtocolKeys.APP_NAME, "坦克大战");
        sdkParams.put(SDKProtocolKeys.PRODUCT_NAME, "金币");
        sdkParams.put(SDKProtocolKeys.AMOUNT, "0.1");
        sdkParams.put(SDKProtocolKeys.NOTIFY_URL, "http://192.168.1.1/notifypage.do");
        sdkParams.put(SDKProtocolKeys.ATTACH_INFO, "你的透传参数");
        sdkParams.put(SDKProtocolKeys.CP_ORDER_ID, "2016000"+System.currentTimeMillis());

        try {
            UCGameSdk.defaultSdk().pay(this, sdkParams);
        } catch (Exception e) {
            e.printStackTrace();
            Log.d(TAG ,"charge failed - Exception: " + e.toString() + "\n");
        }
    }

    /**
     * 如果需要接入登录，请调用本方法
     */
    public void login() {

        try {
            UCGameSdk.defaultSdk().login(this, null);
        } catch (AliLackActivityException e) {
            e.printStackTrace();
        } catch (AliNotInitException e) {
            e.printStackTrace();
        }

    }

    /**
     * 退出游戏前，请调用本方法
     * @param view
     */
    public void exit(View  view) {

        try {
            UCGameSdk.defaultSdk().exit(this, null);
        } catch (Exception e) {
            e.printStackTrace();
            exitApp();
        }
    }

    private void exitApp() {
        finish();
        //退出程序
        Intent intent = new Intent(Intent.ACTION_MAIN);
        intent.addCategory(Intent.CATEGORY_HOME);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
        android.os.Process.killProcess(android.os.Process.myPid());
    }

    @Override
    public void onBackPressed() {
        exit(null);
    }

    private String formatDate(long time, String format) {
        SimpleDateFormat dateformat = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
        dateformat.applyPattern(format);
        return dateformat.format(time);
    }


    /**
     *回调事件
     */
    private SDKEventReceiver receiver = new SDKEventReceiver() {

        @Subscribe(event = SDKEventKey.ON_EXIT_SUCC)
        private void onExit(String desc) {
            Log.d(TAG, "ON_EXIT_SUCC");
            //Toast.makeText(MainActivity.this, ">> 游戏即将退出", Toast.LENGTH_LONG).show();

            exitApp();
        }

        @Subscribe(event = SDKEventKey.ON_EXIT_CANCELED)
        private void onExitCanceled(String desc) {
            runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    //Toast.makeText(MainActivity.this, ">> 继续游戏", Toast.LENGTH_LONG).show();
                }
            });
        }

        @Subscribe(event = SDKEventKey.ON_LOGIN_SUCC)
        private void onLoginSucc(final String sid) {
            runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    if (TextUtils.isEmpty(sid)) {
                        // 离线试玩
                        Toast.makeText(MainActivity.this, ">> 离线登录成功", Toast.LENGTH_LONG).show();
                    } else {
                        // 用户登录
                        Toast.makeText(MainActivity.this, ">> 用户登录成功", Toast.LENGTH_LONG).show();
                    }
                }
            });

        }

        @Subscribe(event = SDKEventKey.ON_LOGIN_FAILED)
        private void onLoginFailed(String desc) {
            runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    Toast.makeText(MainActivity.this, ">> 登录失败", Toast.LENGTH_LONG).show();
                }
            });
        }

        @Subscribe(event = SDKEventKey.ON_INIT_SUCC)
        private void onInitSucc() {
            runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    Toast.makeText(MainActivity.this, ">> 初始化成功", Toast.LENGTH_LONG).show();
                }
            });
        }

        @Subscribe(event = SDKEventKey.ON_INIT_FAILED)
        private void onInitFailed(String msg) {
            runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    Toast.makeText(MainActivity.this, ">> 初始化失败", Toast.LENGTH_LONG).show();
                }
            });
        }

        @Subscribe(event = SDKEventKey.ON_CREATE_ORDER_SUCC)
        private void onPaySucc(final Bundle data) {
            runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    Toast.makeText(MainActivity.this, ">> 支付成功", Toast.LENGTH_LONG).show();
                    Log.d(TAG, "此处为支付成功回调: callback data = " + data.getString("response"));
                }
            });
            String response = data.getString("response");
            // 这里执行发货，如果发货成功需要设置以下值
            data.putString("result", Response.OPERATE_SUCCESS_MSG);
            // 如果发货失败需要设置以下值
            //data.putString("result", Response.OPERATE_FAIL_MSG);
            Log.d(TAG, "pay succ" + data);
        }

        @Subscribe(event = SDKEventKey.ON_PAY_USER_EXIT)
        private void onPayFail(String data) {
            runOnUiThread( new Runnable() {

                @Override
                public void run() {
                    Toast.makeText(MainActivity.this, ">> 支付失败", Toast.LENGTH_LONG).show();
                }
            });
            Log.d(TAG, "pay exit");
        }

        // SDK侧发起的账号切换请求
        // 步骤1，侦听SDK切换账号指令
        @Subscribe(event = SDKEventKey.ON_ACCOUNT_SWITCH_REQUEST)
        private void onAccountSwitchRequest(final String sid) {
            Toast.makeText(MainActivity.this, "侦听到ON_ACCOUNT_SWITCH_REQUEST指令", Toast.LENGTH_SHORT).show();
            //步骤2，CP接入组先退出当前游戏角色
            logoutGameRole();
            //步骤3，和正常登录一样，调用sdk做登录请求
            //这里需要注意：
            //   1. 如果游戏的退出和重新登录在native层是异步的，
            //      那requestLogin()应该由cp自行决定在合适的节点调用，
            //      不要求必须放在onAccountSwitchRequest()方法中；
            //   2. requestLogin()只需要保证在角色已退出的情况下调用即可；
            login();
        }

    };

    private void logoutGameRole() {
        // TODO CP接入组需要在这里实现退出游戏角色的功能；
    }
}

